<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Commission extends Model 
{

    protected $table = 'commissions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('box_id', 'user_id', 'agency_id', 'partner_id', 'slug', 'anount', 'status');
    protected $visible = array('box_id', 'user_id', 'agency_id', 'partner_id', 'slug', 'anount', 'status');

    public function partner()
    {
        return $this->belongsTo('App\Models\Partner', 'partner_id');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function box()
    {
        return $this->belongsTo('App\Models\Box', 'box_id');
    }

    public function agency()
    {
        return $this->belongsTo('App\Models\Agency', 'agency_id');
    }

    public function paymentsCommissions()
    {
        return $this->hasMany('App\Models\PaymentCommission', 'commission_id');
    }

}